import {NgModule} from '@angular/core';
import {CommonModule} from '@angular/common';
import {TranslateModule} from '@ngx-translate/core';
import {FormsModule, ReactiveFormsModule} from '@angular/forms';
import {NgZorroAntdModule} from 'ng-zorro-antd';
import {LoginComponent} from './login/login.component';
import {NotFoundComponent} from './404/404.component';
import {ExtraComponent} from './extra.component';
import {RouterModule} from '@angular/router';

@NgModule({
  imports: [
    FormsModule,
    ReactiveFormsModule,
    CommonModule,
    TranslateModule,
    NgZorroAntdModule,
    RouterModule.forChild([{
      path: '',
      component: ExtraComponent,
      children: [
        {path: '', redirectTo: '/extra/login', pathMatch: 'full'},
        {path: 'login', component: LoginComponent}
      ]
    }])
  ],
  declarations: [ExtraComponent, LoginComponent, NotFoundComponent]
})
export class ExtraModule {
}
