import { Component, OnInit } from '@angular/core';
import {environment} from '../../../environments/environment';
import {en_US, NzMessageService, zh_CN, NzI18nService} from 'ng-zorro-antd';
import { ApiService } from '../../service/api';
import {PermissionService} from '../../service/permission';
import {Router} from '@angular/router';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.scss']
})
export class LoginComponent implements OnInit {
  isLoading = false;
  req: any = {};
  oflflg = false;

  constructor(private api: ApiService, private message: NzMessageService,
              private permission: PermissionService, private router: Router,
              private translate: TranslateService, private nzI18nService: NzI18nService) {
  }

  ngOnInit(): void {
    this.oflflg = environment.offlineFlg == 'OFL' ? true : false;
  }

  login() {
    this.isLoading = true;
    const req = {
      userName: this.req.userName,
      password: this.req.password
    };
    this.api.login.loginForToken([req, (data: any) => {
      if (data.constructor === Object) {
        if (data.code === 1) {
          window.sessionStorage.setItem('_AMap_AMap.MapInner', data.message);
          this.router.navigate(['app/deviceCenter/gatewayMgr']);
          this.getCurUser();
        } else {
          this.message.error(data.message);
        }
      }
      this.isLoading = false;
    }]);
  }

  getCurUser() {
    this.isLoading = true;
    this.api.user.getSelfInfo(['', (data: any) => {
      if (data.userName) {
        window.sessionStorage.setItem(encodeURIComponent('_AMap_AMap.IndoorMapFunc'), encodeURIComponent(data.companyNo));
      } else {
        this.message.error(this.translate.instant('noUserInfo'));
      }
      this.isLoading = false;
    }]);
  }

  // toEn() {
  //   this.translate.use('en');
  //   this.nzI18nService.setLocale(en_US);
  //   document.getElementById('loginBtn').style.letterSpacing = '0px';
  //   localStorage.setItem('witium-default-language', 'en');
  // }
  //
  // toZh() {
  //   this.translate.use('zh');
  //   this.nzI18nService.setLocale(zh_CN);
  //   document.getElementById('loginBtn').style.letterSpacing = '3px';
  //   localStorage.setItem('witium-default-language', 'zh');
  // }
}
