// 引入 angular 动画组件
import { trigger, style, state, transition, animate } from '@angular/animations';

export const fadeDown = trigger('fadeDown', [
  transition('void => *', [
    style({opacity: 0, transform: 'translateY(-50%)'}),
    animate('800ms ease-out', style({transform: 'translateY(0px)', opacity: 1}))
  ]),
  transition('* => void', [
    animate('800ms ease-out', style({opacity: 0, transform: 'translateY(0px)'}))
  ])
]);
